<?php
if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/helpers.php';

if (!isset($_SESSION['van_user_id'])) redirect('index.php');

$customer_id = (int)($_GET['customer_id'] ?? 0);
$loc_id = (int)($_SESSION['van_location_id'] ?? 0);

$c = db()->query("SELECT * FROM customers WHERE id=$customer_id")->fetch_assoc();

$sql = "
  SELECT p.id, p.code, p.description, p.pack_size,
         p.container_type, p.has_deposit,
         p.price_per_case, p.deposit_per_case,
         sb.qty_cases
  FROM stock_balances sb
  JOIN products p ON p.id = sb.product_id
  WHERE sb.location_id = $loc_id
  ORDER BY p.brand, p.name
";
$rows = db()->query($sql);
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Sale – <?= h($c['name'] ?? '') ?></title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container-fluid p-2">
  <div class="mb-2">
    <div class="fw-bold"><?= h($c['name'] ?? 'Customer') ?></div>
    <div class="small text-muted">Deposit Balance: KES <?= number_format($c['deposit_balance'] ?? 0, 2) ?></div>
  </div>

  <form method="post" action="sale_save.php">
    <input type="hidden" name="customer_id" value="<?= $customer_id ?>">
    <div class="table-responsive" style="max-height:55vh;overflow:auto;">
      <table class="table table-sm table-bordered align-middle">
        <thead class="table-light">
          <tr>
            <th>Code</th>
            <th>Product</th>
            <th class="text-end">Stock</th>
            <th class="text-end">Sell (CS)</th>
          </tr>
        </thead>
        <tbody>
        <?php if ($rows): while($r = $rows->fetch_assoc()): ?>
          <tr>
            <td><?= h($r['code']) ?></td>
            <td class="small">
              <?= h($r['description']) ?><br>
              <span class="text-muted"><?= h($r['pack_size']) ?> • <?= h($r['container_type']) ?></span>
            </td>
            <td class="text-end small"><?= number_format($r['qty_cases'],2) ?></td>
            <td class="text-end" style="max-width:80px;">
              <input type="number" step="0.01" min="0" class="form-control form-control-sm text-end"
                     name="qty[<?= (int)$r['id'] ?>]">
            </td>
          </tr>
        <?php endwhile; endif; ?>
        </tbody>
      </table>
    </div>

    <div class="mt-2">
      <label class="form-label small">Payment Type</label>
      <select name="payment_term" class="form-select form-select-sm">
        <option value="CASH">Cash</option>
        <option value="CREDIT">Credit</option>
      </select>
    </div>

    <div class="mt-2">
      <label class="form-label small">Empties Returned (Cases)</label>
      <input type="number" step="0.01" name="empties_cases" class="form-control form-control-sm">
    </div>

    <button class="btn btn-primary w-100 mt-3 btn-sm">Post Sale (Stub)</button>
  </form>
</div>
</body>
</html>
