<?php
$page_title = 'Dashboard';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/sidebar.php';

$res1 = db()->query("SELECT COUNT(*) c FROM products");
$total_products = $res1 ? ($res1->fetch_assoc()['c'] ?? 0) : 0;

$res2 = db()->query("SELECT COUNT(*) c FROM customers");
$total_customers = $res2 ? ($res2->fetch_assoc()['c'] ?? 0) : 0;

$res3 = db()->query("SELECT SUM(qty_cases) s FROM stock_balances");
$total_stock = $res3 ? ($res3->fetch_assoc()['s'] ?? 0) : 0;
?>
<h4 class="mb-3">Dashboard</h4>
<div class="row g-3">
  <div class="col-md-4">
    <div class="card shadow-sm">
      <div class="card-body">
        <div class="text-muted small">Products</div>
        <div class="fs-3 fw-bold"><?= number_format($total_products) ?></div>
      </div>
    </div>
  </div>
  <div class="col-md-4">
    <div class="card shadow-sm">
      <div class="card-body">
        <div class="text-muted small">Customers</div>
        <div class="fs-3 fw-bold"><?= number_format($total_customers) ?></div>
      </div>
    </div>
  </div>
  <div class="col-md-4">
    <div class="card shadow-sm">
      <div class="card-body">
        <div class="text-muted small">Total Stock (Cases)</div>
        <div class="fs-3 fw-bold"><?= number_format($total_stock, 2) ?></div>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
