<?php
$page_title = 'Invoices';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';

$sql = "
  SELECT i.*, c.name AS customer_name
  FROM invoices i
  LEFT JOIN customers c ON c.id = i.customer_id
  ORDER BY i.invoice_date DESC
  LIMIT 100
";
$res = db()->query($sql);
?>
<h4 class="mb-3">Invoices (recent)</h4>
<div class="card shadow-sm">
  <div class="card-body table-responsive">
    <table class="table table-sm table-striped align-middle">
      <thead>
        <tr>
          <th>No</th>
          <th>Date</th>
          <th>Customer</th>
          <th class="text-end">Total</th>
          <th class="text-end">Paid</th>
        </tr>
      </thead>
      <tbody>
      <?php if ($res): while($r = $res->fetch_assoc()): ?>
        <tr>
          <td><?= h($r['invoice_no']) ?></td>
          <td><?= h($r['invoice_date']) ?></td>
          <td><?= h($r['customer_name']) ?></td>
          <td class="text-end"><?= number_format($r['total_amount'],2) ?></td>
          <td class="text-end"><?= number_format($r['amount_paid'],2) ?></td>
        </tr>
      <?php endwhile; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/../../includes/footer.php'; ?>
