<?php
$page_title = 'Products';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';

$res = db()->query("SELECT * FROM products ORDER BY brand, name");
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4 class="mb-0">Products</h4>
  <a href="edit.php" class="btn btn-sm btn-primary">Add Product</a>
</div>
<div class="card shadow-sm">
  <div class="card-body table-responsive">
    <table class="table table-sm table-striped align-middle">
      <thead>
        <tr>
          <th>Code</th>
          <th>Description</th>
          <th>Pack</th>
          <th>Container</th>
          <th class="text-end">Price/CS</th>
          <th class="text-end">Deposit/CS</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
      <?php if ($res): while($p = $res->fetch_assoc()): ?>
        <tr>
          <td><?= h($p['code']) ?></td>
          <td><?= h($p['description']) ?></td>
          <td><?= h($p['pack_size']) ?></td>
          <td><?= h($p['container_type']) ?></td>
          <td class="text-end"><?= number_format($p['price_per_case'],2) ?></td>
          <td class="text-end"><?= number_format($p['deposit_per_case'],2) ?></td>
          <td class="text-end">
            <a href="edit.php?id=<?= (int)$p['id'] ?>" class="btn btn-sm btn-outline-secondary">Edit</a>
          </td>
        </tr>
      <?php endwhile; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/../../includes/footer.php'; ?>
