<?php
$page_title = 'Load Sheets';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';

$res = db()->query("
  SELECT ls.*, sl.name AS van_name
  FROM load_sheets ls
  LEFT JOIN stock_locations sl ON sl.id = ls.van_location_id
  ORDER BY ls.load_date DESC, ls.id DESC
");
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4 class="mb-0">Load Sheets</h4>
  <a href="load_create.php" class="btn btn-sm btn-primary">New Load Sheet</a>
</div>
<div class="card shadow-sm">
  <div class="card-body table-responsive">
    <table class="table table-sm table-striped align-middle">
      <thead>
        <tr>
          <th>Load No</th>
          <th>Date</th>
          <th>Van</th>
          <th>Status</th>
        </tr>
      </thead>
      <tbody>
      <?php if ($res): while($r = $res->fetch_assoc()): ?>
        <tr>
          <td><?= h($r['load_no']) ?></td>
          <td><?= h($r['load_date']) ?></td>
          <td><?= h($r['van_name']) ?></td>
          <td><?= h($r['status']) ?></td>
        </tr>
      <?php endwhile; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/../../includes/footer.php'; ?>
