<?php
$page_title = 'Warehouse Stock';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';

// assume location_id = 1 is main warehouse
$loc_id = 1;
$sql = "
  SELECT p.code,p.description,p.pack_size,p.container_type,sb.qty_cases
  FROM stock_balances sb
  JOIN products p ON p.id = sb.product_id
  WHERE sb.location_id = $loc_id
  ORDER BY p.brand, p.name
";
$res = db()->query($sql);
?>
<h4 class="mb-3">Warehouse Stock</h4>
<div class="card shadow-sm">
  <div class="card-body table-responsive">
    <table class="table table-sm table-striped align-middle">
      <thead>
        <tr>
          <th>Code</th>
          <th>Description</th>
          <th>Pack</th>
          <th>Container</th>
          <th class="text-end">Qty (Cases)</th>
        </tr>
      </thead>
      <tbody>
      <?php if ($res): while($r = $res->fetch_assoc()): ?>
        <tr>
          <td><?= h($r['code']) ?></td>
          <td><?= h($r['description']) ?></td>
          <td><?= h($r['pack_size']) ?></td>
          <td><?= h($r['container_type']) ?></td>
          <td class="text-end"><?= number_format($r['qty_cases'],2) ?></td>
        </tr>
      <?php endwhile; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/../../includes/footer.php'; ?>
